/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************//*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : PRESETTABLE SYNCHRONOUS 4-BIT BINARY UP/DOWN  COUNTER 
TRUTHTABLE     : 
+--------------------------------+-----------------------+
|             INPUT              |                       |
+--------------------------------+       OPERATION       |
|   LOAD_   CTEN_    D_U_  CLK   |                       |
+--------------------------------+-----------------------+
|                                |                       |
|   L        X        X     X    |   Load Parrallel Data |
|                            _   |                       |
|   H        L        L    _/    |   Binary Count Up     |
|                            _   |                       |
|   H        L        H    _/    |   Binary Count Down   |
|                                |                       |
|   H        H        X     X    |   Inhibit Counting    |
+--------------------------------+-----------------------+

   Note : 1. RCO_ goes low at the terminal count for duration
             equal to half clock pulse.
          2. MX_MN goes high for one clock duration at the
             terminal count.
             
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a191 (b, qb, qa, ctenn, dnup, qc, qd, d, c, ldn, maxmin, rcon, clk, a);
	parameter size =1;
	input
		ldn,
		dnup,
		ctenn,
		clk,
		a,
		b,
		c,
		d;
	output
		qa,
		qb,
		qc,
		qd,
		maxmin,
		rcon;
    reg
        NOTIFY_REG;
    not
	N1 (pl, ldn);
    nor
	N2 (en1, pl, ctenn);
    not  
	M191_inst_I1 (m191_inst_wi1, dnup);
    not
	M191_inst_I2 (m191_inst_wi2, clk);
    not  
	M191_inst_I3 (m191_inst_wi3, ldn);
    not  
	M191_inst_I4 (m191_inst_wi4, a);
    not  
	M191_inst_I5 (m191_inst_wi5, b);
    not  
	M191_inst_I6 (m191_inst_wi6, c);
    not  
	M191_inst_I7 (m191_inst_wi7, d);
    not  
	M191_inst_I8 (m191_inst_wi8, ctenn);
    and
	M191_inst_A1 (m191_inst_wa1, m191_inst_qaint, m191_inst_qbint);
    and
	M191_inst_A2 (m191_inst_wa2, m191_inst_wqna, m191_inst_wqnb);
    and
	M191_inst_A3 (m191_inst_wa3, m191_inst_qaint, m191_inst_qbint, m191_inst_qcint);
    and
	M191_inst_A4 (m191_inst_wa4, m191_inst_wqna, m191_inst_wqnb, m191_inst_wqnc);
    nor
	M191_inst_NO1 (m191_inst_wno1, m191_inst_wi1, ctenn);
    nor
	M191_inst_NO2 (m191_inst_wno2, dnup, ctenn);
    xor
	M191_inst_XO1 (m191_inst_wxo1, m191_inst_wi8, m191_inst_qaint);
    xor
	M191_inst_XO2 (m191_inst_wxo2, m191_inst_qaint, m191_inst_qbint);
    xor
	M191_inst_XO3 (m191_inst_wxo3, m191_inst_qbint, m191_inst_wqna);
    xor
	M191_inst_XO4 (m191_inst_wxo4, m191_inst_wa1, m191_inst_qcint);
    xor
	M191_inst_XO5 (m191_inst_wxo5, m191_inst_qcint, m191_inst_wa2);
    xor
	M191_inst_XO6 (m191_inst_wxo6, m191_inst_wa3, m191_inst_qdint);
    xor
	M191_inst_XO7 (m191_inst_wxo7, m191_inst_qdint, m191_inst_wa4);
    nand  
	M191_inst_NA1 (m191_inst_wna1, dd_net_64, m191_inst_wi3);
    nand  
	M191_inst_NA2 (m191_inst_wna2, dd_net_52, m191_inst_wi4);
    nand  
	M191_inst_NA3 (m191_inst_wna3, dd_net_65, m191_inst_wi3);
    nand  
	M191_inst_NA4 (m191_inst_wna4, dd_net_52, m191_inst_wi5);
    nand  
	M191_inst_NA5 (m191_inst_wna5, dd_net_66, m191_inst_wi3);
    nand  
	M191_inst_NA6 (m191_inst_wna6, dd_net_52, m191_inst_wi6);
    nand  
	M191_inst_NA7 (m191_inst_wna7, dd_net_67, m191_inst_wi3);
    nand  
	M191_inst_NA8 (m191_inst_wna8, dd_net_52, m191_inst_wi7);
    nand
	M191_inst_NA21 (m191_inst_wna21, m191_inst_qaint, m191_inst_qbint, m191_inst_qcint, m191_inst_qdint, m191_inst_wi1);
    nand
	M191_inst_NA22 (m191_inst_wna22, m191_inst_wqna, m191_inst_wqnb, m191_inst_wqnc, m191_inst_wqnd, dd_net_72);
    nand
	M191_inst_NA23 (m191_inst_max_minint, m191_inst_wna21, m191_inst_wna22);
    nand  
	M191_inst_NA24 (rcon, m191_inst_max_minint, m191_inst_wi8, m191_inst_wi2);
    buf  
	  (qa, m191_inst_qaint);
    buf  
	  (qb, m191_inst_qbint);
    buf  
	  (qc, m191_inst_qcint);
    buf  
	  (qd, m191_inst_qdint);
    buf  
	  (maxmin, m191_inst_max_minint);
    not
	  (m191_inst_wqna, m191_inst_qaint);
    not
	  (m191_inst_wqnb, m191_inst_qbint);
    not
	  (m191_inst_wqnc, m191_inst_qcint);
    not
	  (m191_inst_wqnd, m191_inst_qdint);
    U_AO_2_2_2
	M191_inst_INST1_inst1 (m191_inst_wna9, m191_inst_wno2, m191_inst_wxo2, ctenn, m191_inst_qbint, m191_inst_wxo3, m191_inst_wno1);
    U_AO_2_2_2
	M191_inst_INST2_inst1 (m191_inst_wna10, m191_inst_wno2, m191_inst_wxo4, ctenn, m191_inst_qcint, m191_inst_wxo5, m191_inst_wno1);
    U_AO_2_2_2
	M191_inst_INST3_inst1 (m191_inst_wna11, m191_inst_wno2, m191_inst_wxo6, ctenn, m191_inst_qdint, m191_inst_wxo7, m191_inst_wno1);
    U_FD_P_RB_SB_NO
	  (m191_inst_qaint, m191_inst_wxo1, clk, m191_inst_wna2, m191_inst_wna1, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m191_inst_qbint, m191_inst_wna9, clk, m191_inst_wna4, m191_inst_wna3, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m191_inst_qcint, m191_inst_wna10, clk, m191_inst_wna6, m191_inst_wna5, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m191_inst_qdint, m191_inst_wna11, clk, m191_inst_wna8, m191_inst_wna7, NOTIFY_REG);
    buf  
	  (dd_net_52, m191_inst_wi3);
    buf  
	  (dd_net_64, a);
    buf  
	  (dd_net_65, b);
    buf  
	  (dd_net_66, c);
    buf  
	  (dd_net_67, d);
    buf  
	  (dd_net_72, dnup);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
